/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.impl.jdbc.UTF8Reader;

public final class ReaderToAscii
extends InputStream {
    private final Reader data;
    private char[] conv;
    private boolean closed;

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        int n = this.data.read();
        if (n == -1) {
            return -1;
        }
        if (n <= 255) {
            return n & 0xFF;
        }
        return 63;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.data instanceof UTF8Reader) {
            return ((UTF8Reader)this.data).readAsciiInto(byArray, n, n2);
        }
        if (n2 > this.conv.length) {
            n2 = this.conv.length;
        }
        if ((n2 = this.data.read(this.conv, 0, n2)) == -1) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2) {
            char c = this.conv[n3];
            int n4 = c <= '\u00ff' ? (int)((byte)c) : 63;
            byArray[n++] = n4;
            ++n3;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        return this.data.skip(l);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.data.close();
        }
    }

    public ReaderToAscii(Reader reader) {
        this.data = reader;
        if (!(reader instanceof UTF8Reader)) {
            this.conv = new char[256];
        }
    }
}

